<?php

namespace VM\AdminBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use FOS\RestBundle\Controller\Annotations\View;
use VM\AdminBundle\Services\ApiGetter;
use VM\AdminBundle\Services\NotesCommunication;
use VM\AdminBundle\Services\RDFExportGeneratorService;
use VM\AdminBundle\Services\SsoCommunication;
use VM\ApiBundle\Entity\Round;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserGroups;
use VM\NotesBundle\Entity\UserNotesQuantity;

class UsersController extends Controller
{
    public function checkIfUserInGroupAction()
    {
        try
        {
            $userData = $this->getRequest()->request->getIterator()->getArrayCopy();

            if(!empty($userData['email']))
            {
                $User = $this->getDoctrine()->getManager()->getRepository('VMApiBundle:User')->findOneBy(array('email' => $userData['email']));

                if(!empty($User))
                {
                    $Group = $User->getGroup();
                    $Teacher = $Group->getUser();
                    return new Response(json_encode(array
                    (
                        'success' =>
                        array
                        (
                            'student_in_group' => true,
                            'can_be_assigned' => $this->checkIfUserCanBeRemovedFromGroup($Group),
                            'group_name' => $Group->getName(),
                            'teacher_name' => $Teacher->getName(),
                            'teacher_surname' => $Teacher->getSurname(),
                            'teacher_email' => $Teacher->getEmail(),
                            'student_name' => $User->getName(),
                            'student_surname' => $User->getSurname(),
                            'hash' => md5($User->getId().'+'.$User->getExternalId())
                        )
                    )));
                }
                else
                {
                    return new Response(json_encode(array('success' => array('student_in_group' => false))));
                }
            }
            else
            {
                throw new \Exception('Missing user email parameter.', 500);
            }
        }
        catch(\Exception $Exception)
        {
            return new Response(json_encode(array('error' => array('message' => $Exception->getMessage(), 'code' => $Exception->getCode()))));
        }
    }

    /**
     * @View(serializerGroups={"details"})
     */
    public function saveAction()
    {
        try
        {
            $userData = $this->getRequest()->request->getIterator()->getArrayCopy();

            $ApiGetter = $this->getApiGetter();
            $SsoCommunication = $this->getSsoCommunication();

            if(empty($userData['id']))
            {
                $User = $this->getDoctrine()->getManager()->getRepository('VMApiBundle:User')->findOneBy(array('email' => $userData['email']));
                $Group = null;
                if(!empty($User))
                {
                    $Group = $User->getGroup();
                    if(empty($userData['hash']) && !empty($Group))
                    {
                        throw new \Exception('Missing security hash.');
                    }
                }

                if(empty($Group))
                {
                    $Group = $ApiGetter->getGroup($userData['group_id']);

                    $response = $SsoCommunication->registerUser($userData['name'], $userData['surname'], $userData['email']);

                    $User = new User();
                    $User->setGroup($Group);
                    $User->setUsername($userData['email']);
                    $User->setName($userData['name']);
                    $User->setSurname($userData['surname']);
                    $User->setEmail($userData['email']);
                    $User->setExternalId($response['user_id']);
                    $User->setRoles(array('ROLE_USER'));

                    $this->getDoctrine()->getManager()->persist($User);


                    $TokensGenerator = $this->get('vm_admin.tokens.generator');
                    $TokensGenerator->getNewTokensList($User, $User);

                    $SsoCommunication->registrationConfirm($User->getExternalId(), $response['confirmation_token']);
                    $result = $SsoCommunication->userGeneratePasswordRecoveryToken($User->getEmail());

                    $this->getDoctrine()->getManager()->flush();

                    $message = \Swift_Message::newInstance()
                        ->setSubject('Rejestracja w Grze Biznesowej')
                        ->setFrom($this->container->getParameter('mailer_from'))
                        ->setTo($User->getEmail())
                        ->setBody(
                            $this->renderView(
                                'VMAdminBundle:Mailer:registration_email.html.twig',
                                array(
                                    'User' => $User,
                                    'result' => $result,
                                    'Teacher' => $Group->getUser()
                                )
                            )
                        )
                    ;
                    $this->get('mailer')->send($message);
                }
                else
                {
                    $OldGroup = $Group;
                    $Group = $ApiGetter->getGroup($userData['group_id']);
                    $User->setGroup($Group);
                    $this->getDoctrine()->getManager()->persist($User);

                    $TokensGenerator = $this->get('vm_admin.tokens.generator');
                    $TokensGenerator->getNewTokensList($User, $User);

                    $this->getDoctrine()->getManager()->flush();

                    $message = \Swift_Message::newInstance()
                        ->setSubject('Zmiana grupy w Grze Biznesowej')
                        ->setFrom($this->container->getParameter('mailer_from'))
                        ->setTo($User->getEmail())
                        ->setBody(
                            $this->renderView(
                                'VMAdminBundle:Mailer:change_group_email.html.twig',
                                array(
                                    'User' => $User,
                                    'Group' => $Group,
                                    'OldGroup' => $OldGroup,
                                    'Teacher' => $Group->getUser(),
                                    'OldTeacher' => $OldGroup->getUser()
                                )
                            )
                        )
                    ;
                    $this->get('mailer')->send($message);
                }
            }
            else
            {
                $User = $ApiGetter->getUser($userData['id']);
                $SsoCommunication->updateUser($User->getExternalId(), array('name' => $userData['name'], 'surname' => $userData['surname']));

                $User->setName($userData['name']);
                $User->setSurname($userData['surname']);
                $this->getDoctrine()->getManager()->flush();
            }

            return $User;
        }
        catch(\Exception $Exception)
        {
            return array('error' => array('message' => $Exception->getMessage(), 'code' => $Exception->getCode()));
        }
    }


    /**
     * @View(serializerGroups={"details"})
     */
    public function deleteAction($userId)
    {
        $ApiGetter = $this->getApiGetter();
        $SsoCommunication = $this->getSsoCommunication();

        $User = $ApiGetter->getUser($userId);

        if(!$ApiGetter->isUserGroup($this->getUser(), $User->getGroup()))
        {
            throw new \Exception('User not belongs to your group');
        }

        $SsoCommunication->deleteUser($User->getExternalId());

        $User->setIsDeleted(true);
        $newEmail = 'delete_' . $User->getId() . '_' . $User->getEmail();
        $User->setEmail($newEmail);
        $User->setUsername($newEmail);
        $User->setExternalId(null);
        $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
        if($Company && !$User->getCompanyRoles()->isEmpty())
        {
            $newRepresentationNumber = ($Company->getRepresentationNumber() > 0) ? $Company->getRepresentationNumber()-1 : 0;
            $Company->setRepresentationNumber($newRepresentationNumber);
        }
        $Roles = $User->getCompanyRoles();
        foreach($Roles as $Role)
        {
            $User->removeCompanyRole($Role);
        }

        $this->getDoctrine()->getManager()->flush();
        return true;
    }


    /**
     * @View(serializerGroups={"details"})
     */
    public function tokensAction($userId)
    {
        $ApiGetter = $this->getApiGetter();
        $User = $ApiGetter->getUser($userId);

        if(!$ApiGetter->isUserGroup($this->getUser(), $User->getGroup()) && $User != $this->getUser())
        {
            throw new \Exception('User not belongs to your group');
        }

        $tokensLists = $User->getTokensList();
        if($tokensLists->count() == 0 || !$tokensLists[0]->getIsActive())
        {
            $TokensGenerator = $this->get('vm_admin.tokens.generator');
            $TokensList = $TokensGenerator->getNewTokensList($User, $this->getUser());

            $this->getDoctrine()->getManager()->flush();
        }
        else
        {
            $TokensList = $tokensLists[0];
        }



        return $TokensList;
    }



    /**
     * @View(serializerGroups={"details"})
     */
    public function tokensGenerateAction($userId)
    {

        $ApiGetter = $this->getApiGetter();
        $User = $ApiGetter->getUser($userId);

        if(!$ApiGetter->isUserGroup($this->getUser(), $User->getGroup()) && $User != $this->getUser())
        {
            throw new \Exception('User not belongs to your group');
        }

        $TokensGenerator = $this->get('vm_admin.tokens.generator');
        $TokensList = $TokensGenerator->getNewTokensList($User, $this->getUser());
        $this->getDoctrine()->getManager()->flush();

        return $TokensList;
    }


    /**
     * @View(serializerGroups={"details"})
     */
    public function sendTokensAction($userId)
    {

        $ApiGetter = $this->getApiGetter();
        $User = $ApiGetter->getUser($userId);

        if(!$ApiGetter->isUserGroup($this->getUser(), $User->getGroup()) && $User != $this->getUser())
        {
            throw new \Exception('User not belongs to your group');
        }


        $message = \Swift_Message::newInstance()
            ->setSubject('Lista tokenów do Gry Biznesowej')
            ->setFrom($this->container->getParameter('mailer_from'))
            ->setTo($User->getEmail())
            ->setBody(
                $this->renderView(
                    'VMAdminBundle:Mailer:tokens_send.html.twig',
                    array(
                        'User' => $User,
                        'Teacher' => $User->getGroup()->getUser(),
                        'TokensList' => $User->getTokensList()->first()
                    )
                )
            )
        ;
        $this->get('mailer')->send($message);

        return true;
    }


    /**
     * @View(serializerGroups={"details"})
     */
    public function getUserStatisticAction()
    {
        $User = $this->getUser();

        $result = array();
        $numberOfNotes = $this->getUsersNumberOfNotes($User->getAdminGroups());

        foreach($User->getAdminGroups() as $Group)
        {
            $group = array(
                'name' => $Group->getName(),
                'users' => array()
            );

            foreach($Group->getUsers() as $Student)
            {
                if($Student->getIsDeleted())
                {
                    continue;
                }
                $stat = $this->getDoctrine()->getRepository('VMApiBundle:UserPageSpentTime')->getUserSpentTimeAndNumberOfLogon($Student->getId());
                $group['users'][] = array(
                    'id' => $Student->getId(),
                    'name' => $Student->getName(),
                    'surname' => $Student->getSurname(),
                    'logged' => (integer)$stat[0]['logged'],
                    'seconds' => (integer)$stat[0]['sec'],
                    'notes' => (!empty($numberOfNotes[$Student->getId()])) ? $numberOfNotes[$Student->getId()] : 0
                );
            }

            $result[] = $group;
        }

        return $result;
    }


    /**
     * @param $groups
     * @return array
     */
    private function getUsersNumberOfNotes($groups)
    {
        $usersIds = array();
        $usersExternalIds = array();
        foreach($groups as $Group)
        {
            /** @var User $User */
            foreach($Group->getUsers() as $User)
            {
                $usersIds[$User->getExternalId()] = $User->getId();
                $usersExternalIds[] = $User->getExternalId();
            }
        }

        $repo = $this->getDoctrine()->getManager('notes')->getRepository('VMNotesBundle:UserNotesQuantity');
        $notes = array();
        if(count($usersExternalIds) > 0)
        {
            $qb = $repo->createQueryBuilder('n')
                ->andWhere('n.user_id IN (:ids)')
                ->setParameter('ids', $usersExternalIds);
            $notes = $qb->getQuery()->getResult();
        }


//        $NotesCommunication = $this->getNotesCommunication();
//        $result = $NotesCommunication->getNumberOfNotes($usersIds);
        $notesResult = array();

        /** @var UserNotesQuantity $note */
        foreach($notes as $note)
        {
            if(isset($usersIds[$note->getUserId()]))
            {
                $notesResult[$usersIds[$note->getUserId()]] = $note->getNotesQuantity();
            }
        }

        return $notesResult;
    }


    /**
     * @return ApiGetter
     */
    protected function getApiGetter()
    {
        return $this->get('vm_admin.api.getter');
    }

    /**
     * @return SsoCommunication
     */
    protected function getSsoCommunication()
    {
        return $this->get('vm_admin.sso.communication');
    }

    /**
     * @return NotesCommunication
     */
    protected function getNotesCommunication()
    {
        return $this->get('vm_admin.notes.communication');
    }

    /*
     * @return Response
     */
    public function getActivityExportAction()
    {
        $User = $this->getUser();
        $filename = 'aktywnosc_uczniow_dla_'.$User->getId().'_'.date("YmdHis").'.n3';
        $path = __DIR__ . '/../../../../web/exports/';

        $data = $this->getRequest()->get('n3data');


        \EasyRdf_Namespace::set('activReport', $this->container->getParameter('rdf_n3_namespace'));
        $RDFGraph = new \EasyRdf_Graph();
        $Res = $RDFGraph->resource($this->container->getParameter('rdf_n3_namespace'));
        $id = 0;
        foreach($data as $key=>$val)
        {
            $id++;
            $userString = 'uczen'.$id;
            foreach($val as $k=>$v)
            {
                $RDFGraph->add($Res, $userString.':'.$k, $v);
            }
        }

        $exportData = $RDFGraph->serialise('turtle');

        $handle = fopen($path.$filename, "w");
        $check = fwrite($handle, $exportData);

        if($check != false)
        {
            $this->getRequest()->getSession()->set('last_generate_file_path', $path.$filename);
            $this->getRequest()->getSession()->set('last_generate_file_name', $filename);
            return new Response('OK');
        }
        else
        {
            $this->getRequest()->getSession()->set('last_generate_file_path', '');
            $this->getRequest()->getSession()->set('last_generate_file_name', '');
            return new Response('ERROR');
        }


    }


     /*
     * @return Response
     */
    public function getNotesExportAction()
    {
        $User = $this->getUser();
        $studentId = $this->getRequest()->get('n3data');
//        $studentId = 363;
        $filename = 'notatki_ucznia'.$studentId.'_dla_user'.$User->getId().'_'.date("YmdHis").'.n3';
        $path = __DIR__ . '/../../../../web/exports/';

        $Student = $this->getDoctrine()->getRepository('VMApiBundle:User')->find($studentId);
        $trueStudentId = $Student->getExternalId();

        $notesList = $this->getDoctrine()->getManager('notes')->getRepository('VM\NotesBundle\Entity\UserNote')->findForUser($trueStudentId);
        if(count($notesList)==0) {return new Response('NO NOTES');}

        \EasyRdf_Namespace::set('notesReport', $this->container->getParameter('rdf_n3_namespace'));
        \EasyRdf_Namespace::set('pole', 'pole');
        $RDFGraph = new \EasyRdf_Graph();
        $Res = $RDFGraph->resource($this->container->getParameter('rdf_n3_namespace'));

        $RDFExport = new RDFExportGeneratorService($this->getDoctrine()->getManager(),$this->container->getParameter('rdf_n3_namespace'));
        $RDFGraph = $RDFExport->objToRDF($RDFGraph,$notesList,$Res);

        $exportData = $RDFGraph->serialise('turtle');

        $handle = fopen($path.$filename, "w");
        $check = fwrite($handle, $exportData);

        if($check != false)
        {
            $this->getRequest()->getSession()->set('last_generate_file_path', $path.$filename);
            $this->getRequest()->getSession()->set('last_generate_file_name', $filename);
            return new Response('OK');
        }
        else
        {
            $this->getRequest()->getSession()->set('last_generate_file_path', '');
            $this->getRequest()->getSession()->set('last_generate_file_name', '');
            return new Response('ERROR');
        }
    }

    protected function checkIfUserCanBeRemovedFromGroup(UserGroups $Group)
    {
        /** @var Round $LastRound */
        $LastRound = $Group->getRounds()->get(7);
        if(!empty($LastRound))
        {
            $LastRoundStartAt = $LastRound->getStartAt();
        }
        else
        {
            $LastRoundStartAt = null;
        }

        /** @var Round $LastStartedRound */
        $LastStartedRoundSequence = 0;
        $LastStartedRoundDate = null;
        $Today = new \DateTime();
        /** @var Round $Round */
        foreach($Group->getRounds() as $Round)
        {
            $startAt = $Round->getStartAt();
            if(!empty($startAt))
            {
                $LastStartedRoundSequence++;
                if($startAt > $LastStartedRoundDate)
                {
                    $LastStartedRoundDate = $startAt;
                }
            }
        }

        if(!empty($LastStartedRoundDate))
        {
            $dateDifference = $Today->diff($LastStartedRoundDate)->format("%a");
        }
        else
        {
            $dateDifference = 1000;
        }

        return
            !empty($LastRoundStartAt) ||
            $dateDifference >= 30;
    }


}
